//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

// This file contains Weapon and Ammo Class/"namespace" helper methods
// as well as hooks into the inventory system. These functions are not
// attached to a specific C++ class or datablock, but define a set of
// methods which are part of dynamic namespaces "class". The Items
// include these namespaces into their scope using the  ItemData and
// ItemImageData "className" variable.

// All ShapeBase images are mounted into one of 8 slots on a shape.
// This weapon system assumes all primary weapons are mounted into
// this specified slot:
$WeaponSlot = 0;


//-----------------------------------------------------------------------------
// Audio profiles

datablock AudioProfile(WeaponUseSound)
{
   filename = "~/data/sound/weapon_switch.wav";
   description = AudioClose3d;
	preload = true;
};

datablock AudioProfile(WeaponPickupSound)
{
   filename = "~/data/sound/weapon_pickup.wav";
   description = AudioClose3d;
	preload = true;
};

datablock AudioProfile(AmmoPickupSound)
{
   filename = "~/data/sound/ammo_pickup.wav";
   description = AudioClose3d;
	preload = true;
};


//-----------------------------------------------------------------------------
// Weapon Class 
//-----------------------------------------------------------------------------

function Weapon::onUse(%data,%obj)
{
   // Default behavoir for all weapons is to mount it into the
   // this object's weapon slot, which is currently assumed
   // to be slot 0
   if (%obj.getMountedImage($WeaponSlot) != %data.image.getId()) {
      serverPlay3D(WeaponUseSound,%obj.getTransform());
      %obj.mountImage(%data.image, $WeaponSlot);
// Ammo text tutorial - dan - 3/7/06
//      AmmoAmount.setText(%obj.getinventory(%data.image.getId().ammo));//this sets the text on use
      if (%obj.client)
         messageClient(%obj.client, 'MsgWeaponUsed', '\c0Weapon selected');
   }
}


function Weapon::onPickup(%this, %obj, %shape, %amount)
{
   // The parent Item method performs the actual pickup.
   // For player's we automatically use the weapon if the
   // player does not already have one in hand.
   if (Parent::onPickup(%this, %obj, %shape, %amount)) {
      serverPlay3D(WeaponPickupSound,%obj.getTransform());
      if (%shape.getClassName() $= "Player" && 
            %shape.getMountedImage($WeaponSlot) == 0)  {
         %shape.use(%this);
      }
   }
}

//-----------------------------------------------------------------------------
// Weapon Image Class
//-----------------------------------------------------------------------------

// Images assume a false ammo state on load.  We need to
// set the state according to the current inventory.
if (%obj.getInventory(%this.ammo)) {

  %obj.setImageAmmo(%slot,true);
  %currentAmmo = %obj.getInventory(%this.ammo);

} else {
  %currentAmmo = 0;
}

%obj.client.setAmmoAmountHud(%currentAmmo);

//-----------------------------------------------------------------------------
// Ammmo Class
//-----------------------------------------------------------------------------

function Ammo::onPickup(%this, %obj, %shape, %amount)
{
   echo("Ammo onPickup call");
   // The parent Item method performs the actual pickup.
   if (Parent::onPickup(%this, %obj, %shape, %amount)) {
      serverPlay3D(AmmoPickupSound,%obj.getTransform());
   }
}

function Ammo::onInventory(%this,%obj,%amount)
{
	echo("Ammo onInventory");
   // The ammo inventory state has changed, we need to update any
   // mounted images using this ammo to reflect the new state.
   for (%i = 0; %i < 8; %i++) {
      if ((%image = %obj.getMountedImage(%i)) > 0)
         if (isObject(%image.ammo) && %image.ammo.getId() == %this.getId()){
            %obj.setImageAmmo(%i,%amount != 0);
            %currentAmmo = %obj.getInventory(%this);
            %obj.client.setAmmoAmountHud(%currentAmmo);
         }
   }
}

//-----------------------------------------------------------------------------
//Ammo Display
//-----------------------------------------------------------------------------

function GameConnection::setAmmoAmountHud(%client, %amount)
{
    commandToClient(%client, 'SetAmmoAmountHud', %amount);
}