$latMoved = 1000/69; 	//(69 miles per minute of latitude)
$PI = 3.14159265359;
$RADIANS = $PI/180.0;

//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// DefaultTrigger is used by the mission editor.  This is also an example
// of trigger methods and callbacks.

datablock TriggerData(DefaultTrigger)
{
   // The period is value is used to control how often the console
   // onTriggerTick callback is called while there are any objects
   // in the trigger.  The default value is 100 MS.
   tickPeriodMS = 100;
};

datablock TriggerData(EdgeOfWorldTrigger)
{
   // The period is value is used to control how often the console
   // onTriggerTick callback is called while there are any objects
   // in the trigger.  The default value is 100 MS.
   tickPeriodMS = 10;
   location = -1;
};

datablock TriggerData(BlockRedrawTrigger)
{
   // The period is value is used to control how often the console
   // onTriggerTick callback is called while there are any objects
   // in the trigger.  The default value is 100 MS.
   tickPeriodMS = 1000;
   location = -1;
};



//-----------------------------------------------------------------------------

function DefaultTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object enters the %trigger
   // area, the object is passed as %obj.  The default onEnterTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,1) method on
   // every object (whatever it's type) in the same group as the trigger.
   Parent::onEnterTrigger(%this,%trigger,%obj);
}

function DefaultTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object leaves the %trigger
   // area, the object is passed as %obj.  The default onLeaveTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,0) method on
   // every object (whatever it's type) in the same group as the trigger.
   Parent::onLeaveTrigger(%this,%trigger,%obj);
}

function DefaultTrigger::onTickTrigger(%this,%trigger)
{
   // This method is called every tickPerioMS, as long as any
   // objects intersect the trigger. The default onTriggerTick
   // method (in the C++ code) invokes the ::onTriggerTick(%trigger) method on
   // every object (whatever it's type) in the same group as the trigger.

   // You can iterate through the objects in the list by using these
   // methods:
   //    %this.getNumObjects();
   //    %this.getObject(n);
   Parent::onTickTrigger(%this,%trigger);
}

function EdgeOfWorldTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object enters the %trigger
   // area, the object is passed as %obj.  The default onEnterTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,1) method on
   // every object (whatever it's type) in the same group as the trigger.
   //Parent::onEnterTrigger(%this,%trigger,%obj);
   echo("Welcome to the trigger");
   
    %client = %obj.client;
    if(!%client)
    {
	echo("not a client!");
	return;
    }
    
    %player = %client.player;
    %currPlayerPos = %player.getPosition();
    //%targetPos = %targetObj.getPosition();
    %targetPos = %player.getPosition();
    
    //%targetPos[1] = 336;
    
    %x = getWord(%targetPos, 0);
    %y = getWord(%targetPos, 1);
    %z = getWord(%targetPos, 2);
    
    //if(%x < -400.1)
    //	%x = 400;
    //else if(%x > 400.1)
    //	%x = -400;
    //else if(%y < -336.)
    //	%y = 336;
    //else if(%y > 336)
    //	%y = -336;
    //else
    //	echo("What do you think you're doing Dave?");
    
    
    $lonMoved = mCeil((1000 / (69 * mAbs(mCos($RADIANS * $PlayerLat)) ) ) * (798/670));
    
    if(%trigger.location == 0)
    {
    	echo("This is the north trigger.");
    	%y = 335;
    	$PlayerLat += $latMoved;
    }
    else if(%trigger.location == 2)
    {
    	echo("This is the south trigger.");
    	%y = -335;  
    	$PlayerLat -= $latMoved;
    }
    else if(%trigger.location == 1)
    {
    	echo("This is the east trigger.");
    	%x = -399;

    	$PlayerLon += $lonMoved;
    	//error($PlayerLon);
    }
    else if(%trigger.location == 3)
    {
    	echo("This is the west trigger.");
    	%x = 399;
    	
    	$PlayerLon -= $lonMoved;
    	//error($PlayerLon);
    }
    else
    {
    	echo("What do you think you're doing Dave? (Bad location type specified - see your developer)");
    }
    
    
    %finalPos = %x SPC %y SPC %z;
    echo("Transforing from" SPC %currPlayerPos SPC "to" SPC %finalPos);
    %player.setTransform(%finalPos);
    
    if(strpos($playerLat, ".", 0) < 1)
	%lat = $PlayerLat @ 0;
    else
	%lat = $PlayerLat * 10;

    if(strpos($playerLon, ".", 0) < 1)
	%lon = $playerLon @ 0;
    else	
	%lon = $playerLon * 10;
    
    error("Going to new lat lon: " @ %lat @ ", " @ %lon);

    
	%command = $GRID_PROTO::LOAD_REGION @ $GRID_PROTO::END_ENTRY @ $GRID_PROTO::END_TUPLE
		 @ %lat @ $GRID_PROTO::END_ENTRY @ %lon @ $GRID_PROTO::END_ENTRY @ "0" @ $GRID_PROTO::END_ENTRY @ $GRID_PROTO::END_TUPLE
		 @ $GRID_PROTO::END_ENTRY @ $GRID_PROTO::END_TUPLE
		 @ $GRID_PROTO::END_COMMAND;
	
	
	$GRID_PROTO::currentTOT = $GRID_PROTO::LOAD_REGION;
	
	clientConnection.sendWithNull(%command);
	error("Sending Command: " @ %command);
   
}

function EdgeOfWorldTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object leaves the %trigger
   // area, the object is passed as %obj.  The default onLeaveTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,0) method on
   // every object (whatever it's type) in the same group as the trigger.
   //Parent::onLeaveTrigger(%this,%trigger,%obj);
   echo("Don't leave me now!!");
}

function EdgeOfWorldTrigger::onTickTrigger(%this,%trigger)
{
   // This method is called every tickPerioMS, as long as any
   // objects intersect the trigger. The default onTriggerTick
   // method (in the C++ code) invokes the ::onTriggerTick(%trigger) method on
   // every object (whatever it's type) in the same group as the trigger.

   // You can iterate through the objects in the list by using these
   // methods:
   //    %this.getNumObjects();
   //    %this.getObject(n);
   //Parent::onTickTrigger(%this,%trigger);   
}


//Block Numbers
//
//              Column 
//       ___ ___ ___ ___ ___
//      |   |   |   |   |   |
//      | 0 | 1 | 2 | 3 | 4 |
//      |___|___|___|___|___|
//   R  |   |   |   |   |   |
//   o	| 5 | 6 | 7 | 8 | 9 |
//   w	|___|___|___|___|___|
//      |   |   |   |   |   |
//      | 10| 11| 12| 13| 14|
//      |___|___|___|___|___|
//
//
//And it wraps around 1 row/2 columns around. For example, the row below Row 3 would be Row 1. So the entire map looks like:
//
//
//Entire Map
//	 ___ ___ ___ ___ ___ ___ ___ ___ ___ 
//      |   |   |   |   |   |   |   |   |   |
//      | 13| 14| 10| 11| 12| 13| 14| 10| 11|
//      |___|___|___|___|___|___|___|___|___|
//      |   |   |   |   |   |   |   |   |   |
//      | 4 | 3 | 0 | 1 | 2 | 3 | 4 | 0 | 1 |
//      |___|___|___|___|___|___|___|___|___|
//      |   |   |   |   |   |   |   |   |   |   
//      | 8 | 9 | 5 | 6 | 7 | 8 | 9 | 5 | 6 |
//      |___|___|___|___|___|___|___|___|___|
//      |   |   |   |   |   |   |   |   |   |
//      | 13| 14| 10| 11| 12| 13| 14| 10| 11|
//      |___|___|___|___|___|___|___|___|___|
//      |   |   |   |   |   |   |   |   |   |
//      | 4 | 3 | 0 | 1 | 2 | 3 | 4 | 0 | 1 |
//      |___|___|___|___|___|___|___|___|___|
//
//

//Triggers
//
//           Row Trig                       Column Trig
//
//	 _______5_______                   __ __ __ __ __
//      |               |                 |  |  |  |  |  |
//      |_______6_______|                 |  |  |  |  |  |
//      |		|                 0  1  2  3  4  |
//      |_______7_______|                 |  |  |  |  |  |
//      |		|                 |  |  |  |  |  |
//      |_______________|                 |__|__|__|__|__|
//
//
//The last row/column doesn't have a trigger, because when that is entered, you teleport and enter in the first row/column,
//   so the last row trigger would really be "5" and last column trigger would be "0"



function BlockRedrawTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object enters the %trigger
   // area, the object is passed as %obj.  The default onEnterTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,1) method on
   // every object (whatever it's type) in the same group as the trigger.
   //Parent::onEnterTrigger(%this,%trigger,%obj);
   
   error("Entering trigger: " @ %trigger.location);
   echo("Redrawing the blocks!!! - and entering");
   
   %client = %obj.client;
   if(!%client)
   {
    	echo("not a client!");
	return;
   }
   
   %player = %client.player;
   %camera = %client.camera;

   $previousLocation = %player.getPosition();
   
   if(%trigger.location >= 0 && %trigger.location < 5)  //Vertical Triggers
      	$previousX = getWord(%player.getPosition(), 0);
   
   else if(%trigger.location >= 5 && %trigger.location < 8)  //Horizontal Triggers
      	$previousY = getWord(%player.getPosition(), 1);
   else
   	echo("What do you think you're redrawing Dave?");
   	
   	
   
   //Redrawing Blocks
   	
   if(%trigger.location == 0)  //2, 7, 12
   {
	fillBlock(2);
	fillBlock(7);
	fillBlock(12);
   }
   else if(%trigger.location == 1) //3, 8, 13
   {
	fillBlock(3);
	fillBlock(8);
	fillBlock(13);
   }
   else if(%trigger.location == 2) //4, 9, 14
   {
	fillBlock(4);
	fillBlock(9);
	fillBlock(14);
   }
   else if(%trigger.location == 3) //0, 5, 10
   {
	fillBlock(0);
	fillBlock(5);
	fillBlock(10);
   }
   else if(%trigger.location == 4) //1, 6, 11
   {
	fillBlock(1);
	fillBlock(6);
	fillBlock(11);
   }
   else if(%trigger.location == 5) //5 - 9
   {
	fillBlock(5);
	fillBlock(6);
	fillBlock(7);
	fillBlock(8);
	fillBlock(9);
   }  
   else if(%trigger.location == 6) //10 - 14
   {
	fillBlock(10);
	fillBlock(11);
	fillBlock(12);
	fillBlock(13);
	fillBlock(14);
   }     
   else if(%trigger.location == 7) //0 - 4
   {
	fillBlock(0);
	fillBlock(1);
	fillBlock(2);
	fillBlock(3);
	fillBlock(4);
   } 
   else
	echo("Out of range.  cannont compute.  bzbbzzb 101000101100100000111");
	
}

function BlockRedrawTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   // This method is called whenever an object leaves the %trigger
   // area, the object is passed as %obj.  The default onLeaveTrigger
   // method (in the C++ code) invokes the ::onTrigger(%trigger,0) method on
   // every object (whatever it's type) in the same group as the trigger.
   //Parent::onLeaveTrigger(%this,%trigger,%obj);
   echo("Redrawing the blocks!!! - and leaving");
   
   %client = %obj.client;
   if(!%client)
   {
    	echo("not a client!");
	return;
   }  
   
   %player = %client.player;

//   $newLocation = %player.getPosition();
   
//   echo("DeltaX = " @ %x2 - %x1 @ "\nDeltaY = " @ %y2 - %y1 @ "\nDeltaZ = " @ %z2 - %z1);
   
   if(%trigger.location >= 0 && %trigger.location < 5)  //Vertical Triggers
   {
   	%newX = getWord(%player.getPosition(), 0);
   	%distance = %newX - $previousX; 
   	
	if(%distance >= 10)
		$playerBlock[0]++;
	else if(%distance <= -10)
		$playerBlock[0]--;
	else
		return;
   }
   else if(%trigger.location >= 5 && %trigger.location < 8)  //Horizontal Triggers
   {
      	%newY = getWord(%player.getPosition(), 1);
      	%distance = %newY - $previousY;
      	
	if(%distance >= 10)
		$playerBlock[1]++;
	else if(%distance <= -10)
		$playerBlock[1]--;
	else
		return;      	
   }
   else
   {
   	echo("What do you think you're redrawing Dave?");
   	return;
   }
   
   echo("Distance: "@%distance);   
}

function BlockRedrawTrigger::onTickTrigger(%this,%trigger)
{
   // This method is called every tickPerioMS, as long as any
   // objects intersect the trigger. The default onTriggerTick
   // method (in the C++ code) invokes the ::onTriggerTick(%trigger) method on
   // every object (whatever it's type) in the same group as the trigger.

   // You can iterate through the objects in the list by using these
   // methods:
   //    %this.getNumObjects();
   //    %this.getObject(n);
   //Parent::onTickTrigger(%this,%trigger);
}