//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Moltov weapon. This file contains all the items related to this weapon
// including explosions, ammo, the item and the weapon item image.
// These objects rely on the item & inventory support system defined
// in item.cs and inventory.cs
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Sounds profiles

datablock AudioProfile(MoltovReloadSound)
{
filename = "~/data/sound/moltov_reload.ogg";
description = AudioClose3d;
preload = true;
};

datablock AudioProfile(MoltovFireSound)
{
filename = "~/data/sound/moltov_firing.ogg";
description = AudioClose3d;
preload = true;
};

datablock AudioProfile(MoltovFireEmptySound)
{
filename = "~/data/sound/moltov_firing_empty.ogg";
description = AudioClose3d;
preload = true;
};

datablock AudioProfile(MoltovExplosionSound)
{
filename = "~/data/sound/moltov_explosion.ogg";
description = AudioDefault3d;
preload = true;
};

//-----------------------------------------------------------------------------
// Moltov bolt projectile splash

datablock ParticleData(MoltovSplashMist)
{
   dragCoefficient      = 2.0;
   gravityCoefficient   = -0.05;
   inheritedVelFactor   = 0.0;
   constantAcceleration = 0.0;
   lifetimeMS           = 400;
   lifetimeVarianceMS   = 100;
   useInvAlpha          = false;
   spinRandomMin        = -90.0;
   spinRandomMax        = 500.0;
   textureName          = "~/data/shapes/moltov/splash";
   
   colors[0]     = "0.7 0.8 1.0 1.0";
   colors[1]     = "0.7 0.8 1.0 0.5";
   colors[2]     = "0.7 0.8 1.0 0.0";
   
   sizes[0]      = 0.5;
   sizes[1]      = 0.5;
   sizes[2]      = 0.8;
   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovSplashMistEmitter)
{
   ejectionPeriodMS = 5;
   periodVarianceMS = 0;
   ejectionVelocity = 3.0;
   velocityVariance = 2.0;
   ejectionOffset   = 0.0;
   thetaMin         = 85;
   thetaMax         = 85;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvance = false;
   lifetimeMS       = 250;
   particles = "MoltovSplashMist";
};

datablock ParticleData( MoltovSplashParticle )
{
   dragCoefficient      = 1;
   gravityCoefficient   = 0.2;
   inheritedVelFactor   = 0.2;
   constantAcceleration = -0.0;
   lifetimeMS           = 600;
   lifetimeVarianceMS   = 0;
   colors[0]     = "0.7 0.8 1.0 1.0";
   colors[1]     = "0.7 0.8 1.0 0.5";
   colors[2]     = "0.7 0.8 1.0 0.0";
   sizes[0]      = 0.5;
   sizes[1]      = 0.5;
   sizes[2]      = 0.5;
   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData( MoltovSplashEmitter )
{
   ejectionPeriodMS = 1;
   periodVarianceMS = 0;
   ejectionVelocity = 3;
   velocityVariance = 1.0;
   ejectionOffset   = 0.0;
   thetaMin         = 60;
   thetaMax         = 80;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvance = false;
   orientParticles  = true;
   lifetimeMS       = 100;
   particles = "MoltovSplashParticle";
};

datablock SplashData(MoltovSplash)
{
   numSegments = 15;
   ejectionFreq = 15;
   ejectionAngle = 40;
   ringLifetime = 0.5;
   lifetimeMS = 300;
   velocity = 4.0;
   startRadius = 0.0;
   acceleration = -3.0;
   texWrap = 5.0;

   texture = "~/data/shapes/moltov/splash";

   emitter[0] = MoltovSplashEmitter;
   emitter[1] = MoltovSplashMistEmitter;

   colors[0] = "0.7 0.8 1.0 0.0";
   colors[1] = "0.7 0.8 1.0 0.3";
   colors[2] = "0.7 0.8 1.0 0.7";
   colors[3] = "0.7 0.8 1.0 0.0";
   times[0] = 0.0;
   times[1] = 0.4;
   times[2] = 0.8;
   times[3] = 1.0;
};

//-----------------------------------------------------------------------------
// Moltov bolt projectile particles
//
//datablock ParticleData(MoltovBoltParticle)
//{
//   textureName          = "~/data/shapes/particles/smoke";
//   dragCoefficient     = 0.5;
//   gravityCoefficient   = -0.1;   // rises slowly
//   inheritedVelFactor   = 0.5;
//   lifetimeMS           = 150;
//   lifetimeVarianceMS   = 10;   // ...more or less
//   useInvAlpha = true;
//   spinRandomMin = -30.0;
//   spinRandomMax = 30.0;
//
//   colors[0]     = "0.7 0.8 1.0 0.4";
//   colors[1]     = "0.7 0.8 1.0 1.0";
//   colors[2]     = "0.7 0.8 1.0 0.0";
//
//   sizes[0]      = 0.15;
//   sizes[1]      = 0.20;
//   sizes[2]      = 0.25;
//
//   times[0]      = 0.0;
//   times[1]      = 0.3;
//   times[2]      = 1.0;
//};
//
//datablock ParticleData(MoltovBubbleParticle)
//{
//   textureName          = "~/data/shapes/particles/bubble";
//   dragCoefficient      = 0.0;
//   gravityCoefficient   = -0.25;   // rises slowly
//   inheritedVelFactor   = 0.0;
//   constantAcceleration = 0.0;
//   lifetimeMS           = 1500;
//   lifetimeVarianceMS   = 600;    // ...more or less
//   useInvAlpha          = false;
//   spinRandomMin        = -100.0;
//   spinRandomMax        = 100.0;
//
//   colors[0]     = "0.7 0.8 1.0 0.4";
//   colors[1]     = "0.7 0.8 1.0 1.0";
//   colors[2]     = "0.7 0.8 1.0 0.0";
//
//   sizes[0]      = 0.2;
//   sizes[1]      = 0.2;
//   sizes[2]      = 0.2;
//
//   times[0]      = 0.0;
//   times[1]      = 0.5;
//   times[2]      = 1.0;
//};
//
//-----------------------------------------------------------------------------------------
// from rocketlauncher
//-----------------------------------------------------------------------------------------

datablock ParticleData( MoltovBoltParticle )
{
	textureName = "~/data/shapes/particles/smokeDark";
	useInvAlpha = false;

	lifetimeMS = 2000;
	lifetimeVarianceMS = 500;

	times[0] = 0.0;
	times[1] = 0.1;
	times[2] = 1;

	colors[0] = "0.7 0.2 0.0 1.0";
	colors[1] = "0.1 0.1 0.1 0.5";
	colors[2] = "0.1 0.1 0.1 0.0";

	sizes[0] = 0.1;
	sizes[1] = 1.5;
	sizes[2] = 0;
};

datablock ParticleEmitterData( MoltovBoltEmitter )
{
	particles = MoltovBoltParticle;

	ejectionPeriodMS = 9;
	periodVarianceMS = 8;

	ejectionVelocity = 1;
	velocityVariance = 0.1;
};


//datablock ParticleEmitterData(MoltovBoltEmitter)
//{
//   ejectionPeriodMS = 2;
//   periodVarianceMS = 0;
//
//   ejectionVelocity = 0.0;
//   velocityVariance = 0.10;
//
//   thetaMin         = 0.0;
//   thetaMax         = 90.0;  
//
//   particles = MoltovBoltParticle;
//};
//
//datablock ParticleEmitterData(MoltovBoltBubbleEmitter)
//{
//   ejectionPeriodMS = 9;
//   periodVarianceMS = 0;
//
//   ejectionVelocity = 1.0;
//   ejectionOffset   = 0.1;
//   velocityVariance = 0.5;
//
//   thetaMin         = 0.0;
//   thetaMax         = 80.0;
//
//  phiReferenceVel  = 0;
//  phiVariance      = 360;
//  overrideAdvances = false;  
//
//   particles = MoltovBubbleParticle;
//};
//
//
//-----------------------------------------------------------------------------
// Explosion Debris

// Debris "spark" explosion
datablock ParticleData(MoltovDebrisSpark)
{
   textureName          = "~/data/shapes/particles/fire";
   dragCoefficient      = 0;
   gravityCoefficient   = 0.0;
   windCoefficient      = 0;
   inheritedVelFactor   = 0.5;
   constantAcceleration = 0.0;
   lifetimeMS           = 500;
   lifetimeVarianceMS   = 50;
   spinRandomMin = -90.0;
   spinRandomMax =  90.0;
   useInvAlpha   = false;

   colors[0]     = "0.8 0.2 0 1.0";
   colors[1]     = "0.8 0.2 0 1.0";
   colors[2]     = "0 0 0 0.0";

   sizes[0]      = 0.2;
   sizes[1]      = 0.3;
   sizes[2]      = 0.1;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovDebrisSparkEmitter)
{
   ejectionPeriodMS = 20;
   periodVarianceMS = 0;
   ejectionVelocity = 0.5;
   velocityVariance = 0.25;
   ejectionOffset   = 0.0;
   thetaMin         = 0;
   thetaMax         = 90;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvances = false;
   orientParticles  = false;
   lifetimeMS       = 300;
   particles = "MoltovDebrisSpark";
};

datablock ExplosionData(MoltovDebrisExplosion)
{
   emitter[0] = MoltovDebrisSparkEmitter;

   // Turned off..
   shakeCamera = false;
   impulseRadius = 0;
   lightStartRadius = 0;
   lightEndRadius = 0;
};

// Debris smoke trail
datablock ParticleData(MoltovDebrisTrail)
{
   textureName          = "~/data/shapes/particles/fire";
   dragCoefficient      = 1;
   gravityCoefficient   = 0;
   inheritedVelFactor   = 0;
   windCoefficient      = 0;
   constantAcceleration = 0;
   lifetimeMS           = 800;
   lifetimeVarianceMS   = 100;
   spinSpeed     = 0;
   spinRandomMin = -90.0;
   spinRandomMax =  90.0;
   useInvAlpha   = true;

   colors[0]     = "0.8 0.3 0.0 1.0";
   colors[1]     = "0.1 0.1 0.1 0.7";
   colors[2]     = "0.1 0.1 0.1 0.0";

   sizes[0]      = 0.2;
   sizes[1]      = 0.3;
   sizes[2]      = 0.4;

   times[0]      = 0.1;
   times[1]      = 0.2;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovDebrisTrailEmitter)
{
   ejectionPeriodMS = 30;
   periodVarianceMS = 0;
   ejectionVelocity = 0.0;
   velocityVariance = 0.0;
   ejectionOffset   = 0.0;
   thetaMin         = 170;
   thetaMax         = 180;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   //overrideAdvances = false;
   //orientParticles  = true;
   lifetimeMS       = 5000;
   particles = "MoltovDebrisTrail";
};

// Debris object
datablock DebrisData(MoltovExplosionDebris)
{
   shapeFile = "~/data/shapes/moltov/debris.dts";
   emitters = "MoltovDebrisTrailEmitter";
   explosion = MoltovDebrisExplosion;
   
   elasticity = 0.6;
   friction = 0.5;
   numBounces = 2;
   bounceVariance = 1;
   explodeOnMaxBounce = true;
   staticOnMaxBounce = false;
   snapOnMaxBounce = false;
   minSpinSpeed = 0;
   maxSpinSpeed = 700;
   render2D = false;
   lifetime = 2;
   lifetimeVariance = 0.4;
   velocity = 5;
   velocityVariance = 0.5;
   fade = false;
   useRadiusMass = true;
   baseRadius = 0.3;
   gravModifier = 0.5;
   terminalVelocity = 6;
   ignoreWater = true;
};


//-----------------------------------------------------------------------------
// Bolt Explosion

datablock ParticleData(MoltovExplosionSmoke)
{
   textureName          = "~/data/shapes/particles/smoke";
   dragCoeffiecient     = 100.0;
   gravityCoefficient   = 0;
   inheritedVelFactor   = 0.25;
   constantAcceleration = -0.30;
   lifetimeMS           = 1200;
   lifetimeVarianceMS   = 300;
   useInvAlpha =  true;
   spinRandomMin = -80.0;
   spinRandomMax =  80.0;

   colors[0]     = "0.56 0.36 0.26 1.0";
   colors[1]     = "0.2 0.2 0.2 1.0";
   colors[2]     = "0.0 0.0 0.0 0.0";

   sizes[0]      = 4.0;
   sizes[1]      = 2.5;
   sizes[2]      = 1.0;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleData(MoltovExplosionBubble)
{
   textureName          = "~/data/shapes/particles/bubble";
   dragCoeffiecient     = 0.0;
   gravityCoefficient   = -0.25;
   inheritedVelFactor   = 0.0;
   constantAcceleration = 0.0;
   lifetimeMS           = 1500;
   lifetimeVarianceMS   = 600;
   useInvAlpha          = false;
   spinRandomMin        = -100.0;
   spinRandomMax        =  100.0;

   colors[0]     = "0.7 0.8 1.0 0.4";
   colors[1]     = "0.7 0.8 1.0 0.4";
   colors[2]     = "0.7 0.8 1.0 0.0";

   sizes[0]      = 0.3;
   sizes[1]      = 0.3;
   sizes[2]      = 0.3;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovExplosionSmokeEmitter)
{
   ejectionPeriodMS = 10;
   periodVarianceMS = 0;
   ejectionVelocity = 4;
   velocityVariance = 0.5;
   thetaMin         = 0.0;
   thetaMax         = 180.0;
   lifetimeMS       = 250;
   particles = "MoltovExplosionSmoke";
};

datablock ParticleEmitterData(MoltovExplosionBubbleEmitter)
{
   ejectionPeriodMS = 9;
   periodVarianceMS = 0;
   ejectionVelocity = 1;
   ejectionOffset   = 0.1;
   velocityVariance = 0.5;
   thetaMin         = 0.0;
   thetaMax         = 80.0;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvances = false;
   particles = "MoltovExplosionBubble";
};

datablock ParticleData(MoltovExplosionFire)
{
   textureName          = "~/data/shapes/particles/fire";
   dragCoeffiecient     = 100.0;
   gravityCoefficient   = 0;
   inheritedVelFactor   = 0.25;
   constantAcceleration = 0.1;
   lifetimeMS           = 1200;
   lifetimeVarianceMS   = 300;
   useInvAlpha =  false;
   spinRandomMin = -80.0;
   spinRandomMax =  80.0;

   colors[0]     = "0.8 0.4 0 0.8";
   colors[1]     = "0.2 0.0 0 0.8";
   colors[2]     = "0.0 0.0 0.0 0.0";

   sizes[0]      = 1.5;
   sizes[1]      = 0.9;
   sizes[2]      = 0.5;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovExplosionFireEmitter)
{
   ejectionPeriodMS = 10;
   periodVarianceMS = 0;
   ejectionVelocity = 0.8;
   velocityVariance = 0.5;
   thetaMin         = 0.0;
   thetaMax         = 180.0;
   lifetimeMS       = 250;
   particles = "MoltovExplosionFire";
};



//------------------------------------------------------------------
//Editted
//------------------------------------------------------------------

datablock ParticleData(MoltovExplosionSparks)
{
   textureName          = "~/data/shapes/particles/spark";
   dragCoefficient      = 1;
   gravityCoefficient   = 0.0;
   inheritedVelFactor   = 0.4;
   constantAcceleration = 0.0;
   lifetimeMS           = 800;
   lifetimeVarianceMS   = 350;

   colors[0]     = "0.60 0.40 0.30 1.0";
   colors[1]     = "0.60 0.40 0.30 1.0";
   colors[2]     = "1.0 0.40 0.30 0.0";

   sizes[0]      = 0.15;
   sizes[1]      = 0.10;
   sizes[2]      = 0.10;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleData(MoltovExplosionWaterSparks)
{
   textureName          = "~/data/shapes/particles/bubble";
   dragCoefficient      = 0;
   gravityCoefficient   = 0.0;
   inheritedVelFactor   = 0.2;
   constantAcceleration = 0.0;
   lifetimeMS           = 500;
   lifetimeVarianceMS   = 350;

   colors[0]     = "0.4 0.4 1.0 1.0";
   colors[1]     = "0.4 0.4 1.0 1.0";
   colors[2]     = "0.4 0.4 1.0 0.0";

   sizes[0]      = 0.5;
   sizes[1]      = 0.5;
   sizes[2]      = 0.5;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MoltovExplosionSparkEmitter)
{
   ejectionPeriodMS = 3;
   periodVarianceMS = 0;
   ejectionVelocity = 5;
   velocityVariance = 1;
   ejectionOffset   = 0.0;
   thetaMin         = 0;
   thetaMax         = 180;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvances = false;
   orientParticles  = true;
   lifetimeMS       = 100;
   particles = "MoltovExplosionSparks";
};

datablock ParticleEmitterData(MoltovExplosionWaterSparkEmitter)
{
   ejectionPeriodMS = 3;
   periodVarianceMS = 0;
   ejectionVelocity = 4;
   velocityVariance = 4;
   ejectionOffset   = 0.0;
   thetaMin         = 0;
   thetaMax         = 60;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   overrideAdvances = false;
   orientParticles  = true;
   lifetimeMS       = 200;
   particles = "MoltovExplosionWaterSparks";
};

datablock ExplosionData(MoltovSubExplosion1)
{
   offset = 0;
   emitter[0] = MoltovExplosionSmokeEmitter;
   emitter[1] = MoltovExplosionSparkEmitter;
};

datablock ExplosionData(MoltovSubExplosion2)
{
   offset = 1.0;
   emitter[0] = MoltovExplosionSmokeEmitter;
   emitter[1] = MoltovExplosionSparkEmitter;
};

datablock ExplosionData(MoltovSubWaterExplosion1)
{
   delayMS   = 100;
   offset    = 1.2;
   playSpeed = 1.5;

   emitter[0] = MoltovExplosionBubbleEmitter;
   emitter[1] = MoltovExplosionWaterSparkEmitter;
   
   sizes[0] = "0.75 0.75 0.75";
   sizes[1] = "1.0 1.0 1.0";
   sizes[2] = "0.5 0.5 0.5";
   times[0] = 0.0;
   times[1] = 0.5;
   times[2] = 1.0;
};

datablock ExplosionData(MoltovSubWaterExplosion2)
{
   delayMS   = 50;
   offset    = 1.2;
   playSpeed = 0.75;

   emitter[0] = MoltovExplosionBubbleEmitter;
   emitter[1] = MoltovExplosionWaterSparkEmitter;

   sizes[0] = "1.5 1.5 1.5";
   sizes[1] = "1.5 1.5 1.5";
   sizes[2] = "1.0 1.0 1.0";
   times[0] = 0.0;
   times[1] = 0.5;
   times[2] = 1.0;
};

datablock ExplosionData(MoltovExplosion)
{
   soundProfile = MoltovExplosionSound;
   lifeTimeMS = 1200;

   // Volume particles
   particleEmitter = MoltovExplosionFireEmitter;
   particleDensity = 75;
   particleRadius = 2;

   // Point emission
   emitter[0] = MoltovExplosionSmokeEmitter;
   emitter[1] = MoltovExplosionSparkEmitter;

   // Sub explosion objects
   subExplosion[0] = MoltovSubExplosion1;
   subExplosion[1] = MoltovSubExplosion2;
   
   // Camera Shaking
   shakeCamera = true;
   camShakeFreq = "10.0 11.0 10.0";
   camShakeAmp = "1.0 1.0 1.0";
   camShakeDuration = 0.5;
   camShakeRadius = 10.0;

   // Exploding debris
   debris = MoltovExplosionDebris;
   debrisThetaMin = 0;
   debrisThetaMax = 60;
   debrisPhiMin = 0;
   debrisPhiMax = 360;
   debrisNum = 6;
   debrisNumVariance = 2;
   debrisVelocity = 1;
   debrisVelocityVariance = 0.5;
   
   // Impulse
   impulseRadius = 10;
   impulseForce = 15;

   // Dynamic light
   lightStartRadius = 6;
   lightEndRadius = 3;
   lightStartColor = "0.5 0.5 0";
   lightEndColor = "0 0 0";
};

datablock ExplosionData(MoltovWaterExplosion)
{
   soundProfile = MoltovExplosionSound;

   // Volume particles
   particleEmitter = MoltovExplosionBubbleEmitter;
   particleDensity = 375;
   particleRadius = 2;


   // Point emission
   emitter[0] = MoltovExplosionBubbleEmitter;
   emitter[1] = MoltovExplosionWaterSparkEmitter;

   // Sub explosion objects
   subExplosion[0] = MoltovSubWaterExplosion1;
   subExplosion[1] = MoltovSubWaterExplosion2;
   
   // Camera Shaking
   shakeCamera = true;
   camShakeFreq = "8.0 9.0 7.0";
   camShakeAmp = "6.0 6.0 6.0";
   camShakeDuration = 1.3;
   camShakeRadius = 20.0;

   // Exploding debris
   debris = MoltovExplosionDebris;
   debrisThetaMin = 0;
   debrisThetaMax = 60;
   debrisPhiMin = 0;
   debrisPhiMax = 360;
   debrisNum = 6;
   debrisNumVariance = 2;
   debrisVelocity = 0.5;
   debrisVelocityVariance = 0.2;
   
   // Impulse
   impulseRadius = 10;
   impulseForce = 15;

   // Dynamic light
   lightStartRadius = 6;
   lightEndRadius = 3;
   lightStartColor = "0 0.5 0.5";
   lightEndColor = "0 0 0";
};

//-----------------------------------------------------------------------------
// Projectile Object

datablock ProjectileData(MoltovProjectile)
{
   projectileShapeName = "~/data/shapes/moltov/projectile.dts";
   directDamage        = 25;
   radiusDamage        = 25;
   damageRadius        = 3;
   explosion           = MoltovExplosion;
   waterExplosion      = MoltovWaterExplosion;


   particleEmitter     = MoltovBoltEmitter;
   particleWaterEmitter= MoltovBoltBubbleEmitter;


   splash              = MoltovSplash;
   thetaMin         = 85;
   thetaMax         = 85;
   phiReferenceVel  = 0;
   phiVariance      = 360;
   spinRandomMin = -80.0;
   spinRandomMax =  80.0;

   muzzleVelocity      = 20;
   velInheritFactor    = 0.3;

   armingDelay         = 0.1;
   lifetime            = 7000;
   fadeDelay           = 3000;
   bounceElasticity    = 0.5;
   bounceFriction      = 0;
   isBallistic         = true;
   gravityMod = 1;

   hasLight    = true;
   lightRadius = 10;
   lightColor  = "0.8 0.2 0.0";

   hasWaterLight     = true;
   waterLightColor   = "0.8 0.2 0.0";
};

function MoltovProjectile::onCollision(%this,%obj,%col,%fade,%pos,%normal)
{
   // Apply damage to the object all shape base objects
   if (%col.getType() & $TypeMasks::ShapeBaseObjectType)
      %col.damage(%obj,%pos,%this.directDamage,"MoltovBolt");
   
//   echo("COLLISION -- " @ %col @ " is getting hit!");
//   echo(%col.getID());
//   echo(%col.name);
//   echo(%col.getClassName());
//   echo("   index is " @ %col.index);
//   echo(%col.interiorFile);
   
   
   if(%col.name $= "Structure")
   {
   	if(%col.copies > 1)
   	{
   		for(%i = 0; %i < %col.copies; %i++)
   		{
   			if(getWord(%col.copyArray, %i) == %col.index)
   			{
   				%thisIndex = %col.index;
   			}
   			else
   			{
   				$interiorObjects[getWord(%col.copyArray, %i)].delete();
   				
				$interiorObjects[getWord(%col.copyArray, %i)] = NULL;
			}
		}
	}
   				//echo("DELETED now SPAWNING");
   	
   	
   				//Get structure id
   				%endPos = strpos(%col.interiorFile, ".", 0);
   				%id = getSubStr(%col.interiorFile, %endPos-1, 1);
   				//echo("ID is " @ %id);
   				
   				for(%i = 0; %i < $StructureInfo.count; %i++)
				{
					if( $StructureInfo.contents[%i, 1] $= %id )	//find the matching id in the structure info script object
					{
						%rowNum = %i;			//once you find the id, mark the row
						%i = $StructureInfo.count;	//then exit the loop
					
					}
				  				
				}
				
				//Determine number of items to drop
				%maxItems = $StructureInfo.contents[%rowNum, 3];	//maxItems that can be placed
				//echo("max items " @ %maxItems);
				%numItems = getRandom(0, %maxItems);			//randomly choose how many will be placed
				//echo("num Items " @ %numItems);
				
				
				//Randomly choose the items to be placed based on their likelihood
				%sum = 0;				
				for(%i = 0; %i < $StructureInfo.contents[%rowNum, 5]; %i++)
					%sum += $StructureInfo.contents[%rowNum, 5, 2 * %i + 1];	//sum up item likelihoods
				//echo("SUM is " @ %sum);
				
				
				for(%i = 0; %i < %numItems; %i++)
				{
					
					%num = getRandom(0, %sum);
					//echo("new num is " @ %num);
					
					%bracket = $StructureInfo.contents[%rowNum, 5, 2 * 0 + 1];	//set first bracket amount
					
					for(%j = 0; %j < $StructureInfo.contents[%rowNum, 5]; %j++)	//iterate through all possible item likelihoods
					{								//to see which bracket the random number fell in
													//this will determine which item is placed
						if( %num > %bracket )
							%bracket += $StructureInfo.contents[%rowNum, 5, 2 * (%j + 1) + 1];	//add the likelihood, and check the next bracket
						else
						{
							
							//we've found the right bracket, now we search the inventory to see which item it is
							for(%k = 0; %k < $inventory.count; %k++)
							{
								if( $inventory.contents[%k, 0] $= $StructureInfo.contents[%rowNum, 5, 2 * %j] )
								{
									%itemName = $inventory.contents[%k, 1];
									
									if( getWord(%itemName, 1) !$= "" )	//if two words, add an underscore
										%itemName = getWord(%itemName, 0) @ "_" @ getWord(%itemName, 1);
	
									%x = getWord(%col.getWorldBoxCenter(), 0);
									%y = getWord(%col.getWorldBoxCenter(), 1);
									%z = getWord(%col.getWorldBoxCenter(), 2);
									
									%z = 103.5;
									
									%offsetX = getRandom(-1, 2);
									%offsetY = getRandom(-1, 2);
									//echo("randomx = " @ %offsetX);
									//echo("randomy = " @ %offsetY);
									
									
									%x += %offsetX;
									%y += %offsetY;
									
									%obj = ItemData::create(%itemName);
									%obj.position = %x @ " " @ %y @ " " @ %z;									
									
									
									//echo(%num @ " yielded " @ %itemName);
									//echo("");
									%k = $inventory.count;
									%j = $StructureInfo.contents[%rowNum, 5];	//break out of loop to choose new random number for item

								}
							}
							
						
						}
						
					
					}
					
				}
				
				
			
  
    				$interiorObjects[%thisIndex] = NULL;
				%col.delete();
   				
			

   }

   // Radius damage is a support scripts defined in radiusDamage.cs
   // Push the contact point away from the contact surface slightly
   // along the contact normal to derive the explosion center. -dbs
   radiusDamage
     (%obj, VectorAdd(%pos, VectorScale(%normal, 0.01)),
      %this.damageRadius,%this.radiusDamage,"Radius",40);
}


//-----------------------------------------------------------------------------
// Ammo Item

datablock ItemData(MoltovAmmo)
{
   // Mission editor category
   category = "Ammo";

   // Add the Ammo namespace as a parent.  The ammo namespace provides
   // common ammo related functions and hooks into the inventory system.
   className = "Ammo";

   // Basic Item properties
   shapeFile = "~/data/shapes/item_8/item_8.dts";
   mass = 1;
   elasticity = 0.2;
   friction = 0.6;

hasLight    = true;
lightRadius = 3;
lightColor  = "0.3 0.1 0.0";
lightType = PulsingLight;
lightTime = 3000;
lightOnlyStatic = False;
	// Dynamic properties defined by the scripts
	pickUpName = "a molotov cocktail";
   maxInventory = 50;
};


//--------------------------------------------------------------------------
// Weapon Item.  This is the item that exists in the world, i.e. when it's
// been dropped, thrown or is acting as re-spawnable item.  When the weapon
// is mounted onto a shape, the MoltovImage is used.

datablock ItemData(Moltov)
{
   // Mission editor category
   category = "Weapon";

   // Hook into Item Weapon class hierarchy. The weapon namespace
   // provides common weapon handling functions in addition to hooks
   // into the inventory system.
   className = "Weapon";

   // Basic Item properties
   shapeFile = "~/data/shapes/moltov/weapon.dts";
   mass = 1;
   elasticity = 0.2;
   friction = 0.6;
   emap = true;

	// Dynamic properties defined by the scripts
	pickUpName = "a molotov cocktail";
	image = MoltovImage;
};


//--------------------------------------------------------------------------
// Moltov image which does all the work.  Images do not normally exist in
// the world, they can only be mounted on ShapeBase objects.

datablock ShapeBaseImageData(MoltovImage)
{
   // Basic Item properties
   shapeFile = "~/data/shapes/moltov/weapon.dts";
   emap = true;

   // Specify mount point & offset for 3rd person, and eye offset
   // for first person rendering.
   mountPoint = 0;

   //eyeOffset = "0.1 0.4 -0.6";
   eyeOffset = 0;

   // When firing from a point offset from the eye, muzzle correction
   // will adjust the muzzle vector to point to the eye LOS point.
   // Since this weapon doesn't actually fire from the muzzle point,
   // we need to turn this off.  
   correctMuzzleVector = false;

   // Add the WeaponImage namespace as a parent, WeaponImage namespace
   // provides some hooks into the inventory system.
   className = "WeaponImage";

   // Projectile && Ammo.
   item = Moltov;
   ammo = MoltovAmmo;
   projectile = MoltovProjectile;
   projectileType = Projectile;

   // Images have a state system which controls how the animations
   // are run, which sounds are played, script callbacks, etc. This
   // state system is downloaded to the client so that clients can
   // predict state changes and animate accordingly.  The following
   // system supports basic ready->fire->reload transitions as
   // well as a no-ammo->dryfire idle state.

   // Initial start up state
   stateName[0]                     = "Preactivate";
   stateTransitionOnLoaded[0]       = "Activate";
   stateTransitionOnNoAmmo[0]       = "NoAmmo";

   // Activating the gun.  Called when the weapon is first
   // mounted and there is ammo.
   stateName[1]                     = "Activate";
   stateTransitionOnTimeout[1]      = "Ready";
   stateTimeoutValue[1]             = 0.6;
   stateSequence[1]                 = "Activate";

   // Ready to fire, just waiting for the trigger
   stateName[2]                     = "Ready";
   stateTransitionOnNoAmmo[2]       = "NoAmmo";
   stateTransitionOnTriggerDown[2]  = "Fire";

   // Fire the weapon. Calls the fire script which does 
   // the actual work.
   stateName[3]                     = "Fire";
   stateTransitionOnTimeout[3]      = "Reload";
   stateTimeoutValue[3]             = 0.2;
   stateFire[3]                     = true;
   stateRecoil[3]                   = LightRecoil;
   stateAllowImageChange[3]         = false;
   stateSequence[3]                 = "Fire";
   stateScript[3]                   = "onFire";
   stateSound[3]                    = MoltovFireSound;

   // Play the reload animation, and transition into
   stateName[4]                     = "Reload";
   stateTransitionOnNoAmmo[4]       = "NoAmmo";
   stateTransitionOnTimeout[4]      = "Ready";
   stateTimeoutValue[4]             = 0.8;
   stateAllowImageChange[4]         = false;
   stateSequence[4]                 = "Reload";
   stateEjectShell[4]               = true;
   stateSound[4]                    = MoltovReloadSound;

   // No ammo in the weapon, just idle until something
   // shows up. Play the dry fire sound if the trigger is
   // pulled.
   stateName[5]                     = "NoAmmo";
   stateTransitionOnAmmo[5]         = "Reload";
   stateSequence[5]                 = "NoAmmo";
   stateTransitionOnTriggerDown[5]  = "DryFire";

   // No ammo dry fire
   stateName[6]                     = "DryFire";
   stateTimeoutValue[6]             = 1.0;
   stateTransitionOnTimeout[6]      = "NoAmmo";
   stateSound[6]                    = MoltovFireEmptySound;
};


//-----------------------------------------------------------------------------

function MoltovImage::onFire(%this, %obj, %slot)
{
   %projectile = %this.projectile;

    %serverammo =  $playerItems[9,3];
    $playerItems[9,3] = %serverammo-1;
    
    
   // Decrement inventory ammo. The image's ammo state is update
   // automatically by the ammo inventory hooks.
   %obj.decInventory(%this.ammo,1);

   // Inventory GUI tutorial - dan - 3/7/06
   %currentAmmo = %obj.getInventory(%this.ammo);
   %obj.client.setAmmoAmountHud(%currentAmmo);

   // Determin initial projectile velocity based on the 
   // gun's muzzle point and the object's current velocity
   %muzzleVector = %obj.getMuzzleVector(%slot);
   %objectVelocity = %obj.getVelocity();
   %muzzleVelocity = VectorAdd(
      VectorScale(%muzzleVector, %projectile.muzzleVelocity),
      VectorScale(%objectVelocity, %projectile.velInheritFactor));

   echo("\c2ON FIRE INFO");
   
   echo(%projectile);
   echo(%muzzleVelocity);
   echo(%obj.getMuzzlePoint(%slot));
   echo(%obj);
   echo(%slot);
   echo(%obj.client);
   echo(%this.projectileType);
   // Create the projectile object
   %p = new (%this.projectileType)() {
      dataBlock        = %projectile;
      initialVelocity  = %muzzleVelocity;
      initialPosition  = %obj.getMuzzlePoint(%slot);
      sourceObject     = %obj;
      sourceSlot       = %slot;
      client           = %obj.client;
   };
   
   echo(%p.getDataBlock().position);
   MissionCleanup.add(%p);
   return %p;
}

function Weapon::onUse(%data,%obj)
{
   // Default behavoir for all weapons is to mount it into the
   // this object's weapon slot, which is currently assumed
   // to be slot 0
   if (%obj.getMountedImage($WeaponSlot) != %data.image.getId()) {
      %obj.mountImage(%data.image, $WeaponSlot);
      AmmoAmount.setText(%obj.getinventory(%data.image.getId().ammo));//this sets the text on use
      if (%obj.client)
         messageClient(%obj.client, 'MsgWeaponUsed', '\c0Weapon selected');
   }
}