//-------------------------------------------------------
// itemTemplateMaker
//
// Called at startup to build script files for every inventory item.
// These script files hold information about the .dts file associated with each modell
//
//-------------------------------------------------------



function createScripts()
{
	%inventory = getInventory();
	
	%file = new FileObject();

	for(%i = 0; %i < %inventory.count; %i++)
	{
		%itemName = %inventory.contents[%i, 1];
		
		
		if( getWord(%itemName, 1) !$= "" )
			%itemName = getWord(%itemName, 0) @ "_" @ getWord(%itemName, 1);
		
		%file.OpenForWrite("fps/data/inventory/" @  %itemName @ ".cs");
		%file.writeLine("datablock ItemData(" @ %itemName @ ")");
		%file.writeLine("{");
		%file.writeLine("\tcategory = \"Item\";");


		//Change back to original item name because .dts file may not have underscore
		%dtsItemName = %inventory.contents[%i, 1];


		%file.writeLine("\tshapeFile = \"~/data/shapes/item_" @ $inventory.contents[%i, 0] @ "/" @ "item_" @ $inventory.contents[%i, 0] @ ".dts\";");
		%file.writeLine("\tmass = 1;");
		%file.writeLine("\tfriction = 1;");
   		%file.writeLine("\telasticity = 0.3;");
		%file.writeLine("\tpickupName = \"some " @ %dtsItemName @ "\";");
		%file.writeLine("\tmaxInventory = " @ %inventory.contents[%i, 5] @ ";");
		
		
		%file.writeLine("hasLight    = true;");
		%file.writeLine("lightRadius = 3;");
		%file.writeLine("lightColor  = \"0.3 0.1 0.0\";");
		%file.writeLine("lightType = PulsingLight;");
		%file.writeLine("lightTime = 3000;");
		%file.writeLine("lightOnlyStatic = False;");
		%file.writeLine("};");		
		%file.close();
		
	}
	
	%file.delete();

}
