//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Misc. server commands avialable to clients
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------

function serverCmdToggleCamera(%client)
{
   %control = %client.getControlObject();
   if (%control == %client.player)
   {
      %control = %client.camera;
      %control.mode = toggleCameraFly;
   }
   else
   {
      %control = %client.player;
      %control.mode = observerFly;
   }
   %client.setControlObject(%control);
}

function serverCmdDropPlayerAtCamera(%client)
{
   if ($Server::TestCheats || isObject(EditorGui))
   {
      %client.player.setTransform(%client.camera.getTransform());
      %client.player.setVelocity("0 0 0");
      %client.setControlObject(%client.player);
   }
}

function serverCmdDropCameraAtPlayer(%client)
{
   %client.camera.setTransform(%client.player.getEyeTransform());
   %client.camera.setVelocity("0 0 0");
   %client.setControlObject(%client.camera);
}


//-----------------------------------------------------------------------------

function serverCmdSuicide(%client)
{
   if (isObject(%client.player))
      %client.player.kill("Suicide");
}   

function serverCmdPlayCel(%client,%anim)
{
   if (isObject(%client.player))
      %client.player.playCelAnimation(%anim);
}

function serverCmdPlayDeath(%client)
{
   if (isObject(%client.player))
      %client.player.playDeathAnimation();
}

//-----------------------------------------------------------------------------

function serverCmdDisplayInventory(%client)
{
   //Had to use a string hack to get the data to the client since arrays do not seem to
   //work in function passing

//sample:
//   if (%client.player.hasInventory("Rifle"))
//        %InvData = "Rifle" @ " " @ %client.player.hasInventory("RifleAmmo") @ " ";
//      
//   if (%client.player.hasInventory("Moltov")) {
//       %InvData = %InvData @ "Moltov" @ " " @ %client.player.hasInventory("MoltovAmmo") @ " ";
//   }



       if (%client.player.hasInventory("Moltov")) {   	
   	%InvData = "Moltov" @ " " @ %client.player.hasInventory("MoltovAmmo") @ " ";
       }


       if (%client.player.hasInventory("Budlight")) {
   	%InvData = %InvData @ "Budlight" @ " " @ %client.player.hasInventory("BudlightAmmo") @ " ";
       }


       if (%client.player.hasInventory("Cigs")) {   	
   	%InvData = %InvData @ "Cigs" @ " " @ %client.player.hasInventory("CigsAmmo") @ " ";
       }

       if (%client.player.hasInventory("Prozac")) { 
       %InvData = %InvData @ "Prozac" @ " " @ %client.player.hasInventory("Prozac") @ " ";      
       }
     
       if (%client.player.hasInventory("Burger")) { 
       %InvData = %InvData @ "Burger" @ " " @ %client.player.hasInventory("Burger") @ " ";
       }
      
       if (%client.player.hasInventory("Porn")) { 
       %InvData = %InvData @ "Porn" @ " " @ %client.player.hasInventory("Porn") @ " ";
       }

       if (%client.player.hasInventory("Beads")) { 
       %InvData = %InvData @ "Beads" @ " " @ %client.player.hasInventory("Beads") @ " ";
       }

       if (%client.player.hasInventory("Ritalin")) { 
       %InvData = %InvData @ "Ritalin" @ " " @ %client.player.hasInventory("Ritalin") @ " ";
       }
    
       if (%client.player.hasInventory("StarOfTustin")) { 
       %InvData = %InvData @ "Star of Tustin" @ " " @ %client.player.hasInventory("StarOfTustin") @ " ";
       }     
     
       if (%client.player.hasInventory("StarOfIrvine")) { 
       %InvData = %InvData @ "Star of Irvine" @ " " @ %client.player.hasInventory("StarOfIrvine") @ " ";
       }          
       
   //Send the info to the client to display it   
   commandToClient(%client, 'PopInventory',%InvData);
  
}
