$server = "unexceptional.arts.uci.edu";
$port = 7705;

connect()
{
	%address = $server @ ":" @ $port;
	
	new TCPObject(clientConnection);
	
	$connected = false;
	
	clientConnection.connect(%address);
}

logOn(%phoneNumber)
{
	if($connected)
	{
		%command = "Au|:" @ %phoneNumber @ "|:" @ '\0';
	
		clientConnection.send(%command);
	}
	else
		echo("Could not log on:  No connection established");
}


// This is one of the standard callbacks for TCPObject.
// Whenever the TCPobject is disconnected from an active
// connection, this callback is called automaticly by the
// engine.
function clientConnection::onDisconnect(%this)
{
   	guiOnText("You have been disconnected.");
	$connected = false;
	clientConnection.destroy();
}

// This is one of the standard callbacks for TCPObject.
// Whenever the TCPobject connects to a server this
// callback is called automaticly by the engine.
function clientConnection::onConnected(%this)
{
	guiOnText("Welcome to the Unexceptional");
	$connected = true;
}

// This is one of the standard callbacks for TCPObject.
// Whenever the TCPobject tries to connect to a server but
// fails to make a connection, this callback is called
// automaticly by the engine.
function clientConnection::onConnectFailed(%this)
{
   	guiOnText("Connection to server failed!");
}

// This is one of the standard callbacks for TCPObject.
// Whenever the TCPobject receives a line of text
// this callback is called automaticly by the engine.
function clientConnection::onLine(%this, %data)
{
	%delim_pos = strpos(%line, $GRID_PROTO::DELIM);

	echo("command: " @ $GRID_PROTO::currentTOT );

	if($GRID_PROTO::currentTOT $= "0")
	{
		echo(%line);
	}
	else
	{
		if( $GRID_PROTO::currentTOT $= $GRID_PROTO::RECEIVE_INV)
		{
			recvInventory(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::SEND_INV)
		{
			sendInventory(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::SEND_STATS)
		{
			sendStats(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::RECEIVE_STATS)
		{
			recvStats(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::AUTH_USER)
		{
			authorizedUser(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::QUERY_PLAYER_ID)
		{
			$userid = userAuth(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::GET_STREET_IMG_LOC)
		{
			getStreetTexLoc(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::GET_STRUCTURE_IMG_LOC)
		{
			getImgLoc(%data);
		}
		else if( $GRID_PROTO::currentTOT $= $GRID_PROTO::GET_REGION_INFO)
		{
			getRegionInfo(%data);
		}
		else
		{
			echo("ERROR: " @ %data);
		}
	}
}