//-------------------------------------------------
// InventoryGui.cs
//-------------------------------------------------

$InvWordCount = 0;
$CurrentBottomSlot = 4;

new ActionMap(InvMap);
    InvMap.bindCmd(keyboard, "ctrl i", "toggleInventory();", "");
    InvMap.bindCmd(keyboard, "escape", "toggleInventory();", "");

function InventoryGui::onWake()
{
    InvpName.setText("Inventory for " @ $pref::Player::Name);
    $enableDirectInput = "1";
    activateDirectInput();

    InvMap.push();
}

function InventoryGui::onSleep()
{
    InvMap.pop();
}

function setInventory(%updatedInventory)
{
	$inventory = %updatedInventory;
}

function getInventory()
{
	return $inventory;
}

function showInventoryGui()
{
	//Store updated inventory locally for scrolling while in the inventory gui

	//Initialize another array with inventory items that are visible
	//in order to view during scrolling
	
	%inventory = getInventory();
	%count = 0;
	
	//Counts number of visible items
	for(%i = 0; %i < %inventory.count; %i++)
	{
		if( ((%inventory.contents[%i,3] > 0) && (%inventory.contents[%i,4] > 0))	//if a chakra key AND greater than 0
			|| ((%inventory.contents[%i,6] == 1) && (%inventory.contents[%i,3] > 0)))	// OR if visible AND greater than 0
			%count++;
	}

	
	$visibleItems[%count, $GRID_PROTO::NUM_OF_ITEM_DATA] = "";	//initialize array
	$num_visible_items = %count;
	
	%temp= 0;
	
	for(%i = 0; %i < %inventory.count; %i++)
	{
		if( ((%inventory.contents[%i,3] > 0) && (%inventory.contents[%i,4] > 0))	//if a chakra key AND greater than 0
			|| ((%inventory.contents[%i,6] == 1) && (%inventory.contents[%i,3] > 0)) )	// OR if visible AND greater than 0
		{
			for(%j = 0; %j < 7; %j++)
			{
				$visibleItems[%temp, %j] = %inventory.contents[%i, %j];
			}
			%temp++;
		}
		
	}
	

	$topOfPage = 0;

	//***format:ID || Item Name || Item Description || Amt Held || Amt Used ***

	if(%count > 0)  //Slot 1
	{
		Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[0, 1] @ ".png");
		Slot1Desc.setText($visibleItems[0, 1] @ ": " @ $visibleItems[0, 3]);
	}
	else  //Empty Slot
	{
		Slot1.setBitmap("fps/client/ui/Inv/InvEmpty.png");
		Slot1Desc.setText(" ");
	}

	if(%count > 1)  //Slot 2
	{
		Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[1, 1] @ ".png");
		Slot2Desc.setText($visibleItems[1, 1] @ ": " @ $visibleItems[1, 3]);
	}
	else  //Empty Slot
	{
		Slot2.setBitmap("fps/client/ui/Inv/InvEmpty.png");
		Slot2Desc.setText(" ");
	}

	if(%count > 2)  //Slot 3
	{
		Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[2, 1] @ ".png");
		Slot3Desc.setText($visibleItems[2, 1] @ ": " @ $visibleItems[2, 3]);
	}
	else  //Empty Slot
	{
		Slot3.setBitmap("fps/client/ui/Inv/InvEmpty.png");
		Slot3Desc.setText(" ");
	}

	if(%count > 3)  //Slot 4
	{
		Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[3, 1] @ ".png");
		Slot4Desc.setText($visibleItems[3, 1] @ ": " @ $visibleItems[3, 3]);
	}
	else  //Empty Slot
	{
		Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
		Slot4Desc.setText(" ");
	}

	Canvas.setContent( InventoryGui );

}



//--------------------------------------------------------------------
// "Arrow Keys"
//--------------------------------------------------------------------

function InvUpArrowEvt::onMouseDown(%this, %obj)
{
   if($topOfPage > 0)
   {
        $topOfPage--;

        Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage, 1] @ ".png");
    	Slot1Desc.setText($visibleItems[$topOfPage, 1] @ ": " @ $visibleItems[$topOfPage, 3]);

    	Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 1, 1] @ ".png");
    	Slot2Desc.setText($visibleItems[$topOfPage + 1, 1] @ ": " @ $visibleItems[$topOfPage + 1, 3]);

    	Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 2, 1] @ ".png");
    	Slot3Desc.setText($visibleItems[$topOfPage + 2, 1] @ ": " @ $visibleItems[$topOfPage + 2, 3]);

    	Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 3, 1] @ ".png");
    	Slot4Desc.setText($visibleItems[$topOfPage + 3, 1] @ ": " @ $visibleItems[$topOfPage + 3, 3]);
    }

    if ($InvWordCount > 8 && $CurrentBottomSlot > 4) {

      $CurrentBottomSlot--;

        Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-4] @ ".png");
      Slot1Desc.setText($WeaponTokens[$CurrentBottomSlot-4] @ ": " @ $AmmoTokens[$CurrentBottomSlot-4]);

        Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-3] @ ".png");
      Slot2Desc.setText($WeaponTokens[$CurrentBottomSlot-3] @ ": " @ $AmmoTokens[$CurrentBottomSlot-3]);

        Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-2] @ ".png");
      Slot3Desc.setText($WeaponTokens[$CurrentBottomSlot-2] @ ": " @ $AmmoTokens[$CurrentBottomSlot-2]);

        Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-1] @ ".png");
      Slot4Desc.setText($WeaponTokens[$CurrentBottomSlot-1] @ ": " @ $AmmoTokens[$CurrentBottomSlot-1]);

   }
}

function InvDownArrowEvt::onMouseDown(%this, %obj)
{
  if($topOfPage + 4 < $num_visible_items)
    {
    	$topOfPage++;

    	Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage, 1] @ ".png");
	Slot1Desc.setText($visibleItems[$topOfPage, 1] @ ": " @ $visibleItems[$topOfPage, 3]);

	Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 1, 1] @ ".png");
	Slot2Desc.setText($visibleItems[$topOfPage + 1, 1] @ ": " @ $visibleItems[$topOfPage + 1, 3]);

	Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 2, 1] @ ".png");
	Slot3Desc.setText($visibleItems[$topOfPage + 2, 1] @ ": " @ $visibleItems[$topOfPage + 2, 3]);

	Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $visibleItems[$topOfPage + 3, 1] @ ".png");
	Slot4Desc.setText($visibleItems[$topOfPage + 3, 1] @ ": " @ $visibleItems[$topOfPage + 3, 3]);
    }


    if ($InvWordCount > 8 && $CurrentBottomSlot < ($InvWordCount/2)) {

       $CurrentBottomSlot++;

        Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-4] @ ".png");
       Slot1Desc.setText($WeaponTokens[$CurrentBottomSlot-4] @ ": " @ $AmmoTokens[$CurrentBottomSlot-4]);

        Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-3] @ ".png");
      Slot2Desc.setText($WeaponTokens[$CurrentBottomSlot-3] @ ": " @ $AmmoTokens[$CurrentBottomSlot-3]);

        Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-2] @ ".png");
      Slot3Desc.setText($WeaponTokens[$CurrentBottomSlot-2] @ ": " @ $AmmoTokens[$CurrentBottomSlot-2]);

        Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[$CurrentBottomSlot-1] @ ".png");
      Slot4Desc.setText($WeaponTokens[$CurrentBottomSlot-1] @ ": " @ $AmmoTokens[$CurrentBottomSlot-1]);

   }
}



function clientCmdPopInventory(%InvData) {

    //String Hack since I couldn't get arrays to pass
    $InvWordCount = getWordCount(%InvData);

    //reset the Bottom Slot to default
    $CurrentBottomSlot = 4;

    %InvWdCount = 0;
    if ($InvWordCount > 0) {

        for (%i = 0; %i < ($InvWordCount/2); %i++) {
          $WeaponTokens[%i] = getWord(%InvData,%InvWdCount);
            %InvWdCount++;
            $AmmoTokens[%i] = getWord(%InvData,%InvWdCount);
          %InvWdCount++;
      }


   }

    if ($InvWordCount > 0) {  //Slot 1
         Slot1.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[0] @ ".png");
       Slot1Desc.setText($WeaponTokens[0] @ ": " @ $AmmoTokens[0]);
    } else {
        Slot1.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot1Desc.setText(" ");
   }


   if ($InvWordCount > 2) {  //Slot 2
         Slot2.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[1] @ ".png");
       Slot2Desc.setText($WeaponTokens[1] @ ": " @ $AmmoTokens[1]);
    } else {
        Slot2.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot2Desc.setText(" ");
   }

   if ($InvWordCount > 4) {  //Slot 3
         Slot3.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[2] @ ".png");
       Slot3Desc.setText($WeaponTokens[2] @ ": " @ $AmmoTokens[2]);
    } else {
        Slot3.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot3Desc.setText(" ");
   }

//    if ($InvWordCount > 6) {  //Slot 4
//         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[3] @ ".png");
//       Slot4Desc.setText($WeaponTokens[3] @ ": " @ $AmmoTokens[3]);
//    } else {
//        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
//         Slot4Desc.setText(" ");
//   }

    if ($InvWordCount > 8) {  //Slot 5
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[4] @ ".png");
       Slot4Desc.setText($WeaponTokens[4] @ ": " @ $AmmoTokens[4]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 10) {  //Slot 6
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[5] @ ".png");
       Slot4Desc.setText($WeaponTokens[5] @ ": " @ $AmmoTokens[5]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 12) {  //Slot 7
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[6] @ ".png");
       Slot4Desc.setText($WeaponTokens[6] @ ": " @ $AmmoTokens[6]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 14) {  //Slot 8
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[7] @ ".png");
       Slot4Desc.setText($WeaponTokens[7] @ ": " @ $AmmoTokens[7]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 16) {  //Slot 9
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[8] @ ".png");
       Slot4Desc.setText($WeaponTokens[8] @ ": " @ $AmmoTokens[8]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 18) {  //Slot 10
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[9] @ ".png");
       Slot4Desc.setText($WeaponTokens[9] @ ": " @ $AmmoTokens[9]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }

    if ($InvWordCount > 6) {  //Slot 4
         Slot4.setBitmap("fps/client/ui/Inv/Inv" @ $WeaponTokens[3] @ ".png");
       Slot4Desc.setText($WeaponTokens[3] @ ": " @ $AmmoTokens[3]);
    } else {
        Slot4.setBitmap("fps/client/ui/Inv/InvEmpty.png");
         Slot4Desc.setText(" ");
   }


    Canvas.setContent( InventoryGui );
}