//----------------------------------------------------------------------------
// Originally coded by Andrew Hsu
// Modified by Brian Hein, 07-17-05
//----------------------------------------------------------------------------

// Create a TCPObject to be used for connecting to the server
new TCPObject(JpegTCPObj);

function getfile(%site,%port,%filepath,%saveTo,%temp,%count)
{
	// Connect to the download site and check that the file we are downloading
	// is new, not one we already have.
	JpegTCPObj.site = %site;
	JpegTCPObj.port = %port;
	JpegTCPObj.saveTo = %saveTo@%temp;
	JpegTCPObj.filepath = %filePath@%temp;
	echo("JpegTCPObj.filepath = " @ JpegTCPObj.filepath);
	JpegTCPObj.setBinary(true);
	JpegTCPObj.connect(JpegTCPObj.site@":"@JpegTCPObj.port);
	$fileCounter = %count++;
}

//----------------------------------------------------------------------------
// When we're connected send
// a GET request with the URL
// of the file we want
//----------------------------------------------------------------------------

function JpegTCPObj::onConnected(%this)
{
    // Output 'error' instead of 'echo' to gen red text to show we connected
	error("Connected: http://"@%this.site);
	
	// Send the request for the file to the server
	error("Requesting: " @%this.filePath);
	%this.send("GET "@%this.filePath@ "\n\r\n");//@" HTTP/1.1\nHost: "@%this.site@"\nUser-Agent: Torque/1.0 \n\r\n");
}

// The server will disconnect once it has finished transmitting the data. So save it then.
function JpegTCPObj::onDisconnect(%this){
	//Should probably check to see if we got it all..
	error("Downloaded new file: /"@%this.saveTo);
	
	$currentProgress = $currentProgress + (1/($maxCount-9));
	
	LoadProgress.setValue($currentProgress);
	echo($currentProgress);
	
	%x = $currentProgress;
	
	if (%x >= 1)
	{
		StartupGui.done = true;
		loadMainMenu();
	}
	//Save what we have buffered to a file.
	%this.saveBufferToFile(%this.saveTo);
	//$Pref::newestPicture = %this.filePath;
	if ($fileCounter < $maxCount)
	{
		%getFile = false;
		while ((%getFile != true) && ($fileCounter < $maxCount))
		{
			%tempName = $newArray2[$fileCounter,0];
			%tempCounter = 0;
			%matches = false;

			while (%tempCounter <= $oldCount)
			{
				%oldtempName = $oldArray2[%tempCounter,0];

				if (%tempName$=%oldtempName)
				{
					$newfileCounter = %tempCounter;
					%matches = true;
				}
				%tempCounter++;
			}
			if ($oldArray2[$newfileCounter,3] != $newArray2[$fileCounter,3])
			{
				%getFile = true;
				file_name.setText($newArray2[$fileCounter,0]);

				getfile(%this.site,%this.port,$newArray2[$fileCounter,1],
				$newArray2[$fileCounter,2],$newArray2[$fileCounter,0],$fileCounter);
			}
			else if (%matches != true)
			{
				%getFile = true;
				file_name.setText($newArray2[$fileCounter,0]);
				getfile(%this.site,%this.port,$newArray2[$fileCounter,1],
				$newArray2[$fileCounter,2],$newArray2[$fileCounter,0],$fileCounter);
			}
			else
			{
				file_name.setText($newArray2[$fileCounter,0]);

				error($newArray2[$fileCounter,0]@" is already the most updated version.");
				$currentProgress = $currentProgress + (1/($maxCount-9));

				LoadProgress.setValue($currentProgress);
				echo($currentProgress);
				
				%y = $currentProgress;
				
				if (%y >= 1)
				{
					StartupGui.done = true;
					loadMainMenu();
				}
				$fileCounter++;
			}
		}
	}
}

//----------------------------------------------------------------------------
// Parse the return from the server.
// Go through this till we get past the header and into the data.
// Gets called for each line of ASCII recieved. (while isBinary is false)
// Should get the filesize and stuff out of the header here.
//----------------------------------------------------------------------------

function JpegTCPObj::onLine(%this, %line)
{
	%currentLine = %this.lastLine;
	echo(%line);
	%this.lastLine = %line;
}
// End
