//----------------------------------------------------------------------------
// Originally coded by Andrew Hsu
// Modified by Brian Hein, 07-17-05
// Modified by Pedram Javidpour, 08-28-05
//----------------------------------------------------------------------------

exec("./getfile.cs");

// Create a TCPObject to be used for connecting to the server
new TCPObject(TCPObj);
new FileObject(oldFile);
TCPObj.site  = "unexceptional.arts.uci.edu";
TCPObj.port  = "80";

//The filename is just after this string all of the time.
TCPObj.index = "NEW/";

//This is the website that contains the link (or filename) to the file that will be downloaded.
//This website is downloaded, and then searched through for index (see above)
//Then it is assumed that the string directly after index until the next space is the filename
TCPObj.updateFile = "/3d/models/update.txt";

$maxCount = 0;
$oldCount = 0;
$updateFile = true;
$currentProgress = 0;

//-------------------------
// Function to connect and
// grab the website (HTML).
//-------------------------

function getNewFiles()
{
	// Connect to the site with a link to the file we want to download.
	echo("Update Connecting...");
	//$newArray[$maxCount] = new array();
	TCPObj.connect(TCPObj.site@":"@TCPObj.port);
	//TCPObj.connect("unexceptional.arts.uci.edu:80");
	echo("Connecting to: " @ TCPObj.site @ ":" @ TCPObj.port);
	echo("Post Update Connecting...");
}

// Torque automatiacally calls this function once the TCPObj.connect(...) call (from getNewFiles() ) succeeds
function TCPObj::onConnected(%this)
{
	// Output red text to show we connected
	error("Connected: " @ %this.site);

    //Sends the request to get the update.txt file to the server
	%this.send("GET "@%this.updateFile@" HTTP/1.1\nHost: "@%this.site@"\nUser-Agent: Torque/1.0 \n\r\n");
}

function TCPObj::onConnectFailed(%this)
{
	echo("Update: Connection to server failed!");
}

//The server will disconnect once it has finished transmitting.
//Called after we have received update.txt and stored the information in $newArray2
function TCPObj::onDisconnect(%this){
	
	echo("Finished checking files.");
	
	// Read info from old file stored locally on client
	oldFile.openForRead("fps/data/update.txt");
	
	// Read all lines from the file and store them in $oldArray
	while (!oldFile.isEOF())
	{
		
		$oldCount++;
		$oldArray[$oldCount] = oldFile.readLine();
		error("Line "@$oldCount@" of update.txt: "@$oldArray[$oldCount]);
	}
	oldFile.close();
   
   // Write contents of newArray to fps/data/update.txt file - Pedram

   // Break up lines in $oldArray
   for (%i = 0; %i <= $oldCount; %i++)
	{
		%temp = $oldArray[%i];
		
		%temp0 = GetWord(%temp, 0);
		%temp1 = GetWord(%temp, 1);
		%temp2 = GetWord(%temp, 2);
		%temp3 = GetWord(%temp, 3);
		%temp4 = GetWord(%temp, 4);
		%temp5 = GetWord(%temp, 5);		

		$oldArray2[%i,0] = %temp0;
		$oldArray2[%i,1] = %temp1;
		$oldArray2[%i,2] = %temp2;
		$oldArray2[%i,3] = %temp3;
		$oldArray2[%i,4] = %temp4;
		$oldArray2[%i,5] = %temp5;

		/////////////TEST TO SEE IF LOCAL UPDATE.TXT CONTAINS CORRECT INFORMATION////////////////////

		%filename = $oldArray2[%i,2]@$oldArray2[%i,0];
		error(%filename);
		%local = new FileObject();
		if(%local.openForRead(%filename))
		  error(%filename@" exists!");
		else
		{
		   error("Error: "@%filename@" does not exist.");
		   for(%j =0;%j<6;%j++)
		   	$oldArray2[%i,%j] = "";
		   	
		}
	
		
		
	}

	//Update comparison to use new date / timestamp instead of "version"  - Pedram
	if ($oldArray2[0,3] != $newArray2[9,3])
	{
		file_name.setText($newArray2[9,0]);

		echo("Getting File: " @ $newArray2[9,0]);
		LoadProgress.setValue($currentProgress);
		getfile(%this.site,%this.port,$newArray2[9,1],
		$newArray2[9,2],$newArray2[9,0], 9);
   }
   else
   {
		echo($newArray2[9,0]@" is already the most updated version.");
		LoadProgress.setValue($currentProgress);
		StartupGui.done = true;
		loadMainMenu();
   }
   
    new FileObject(localUpdate);
    
    //Write the Local update.txt
    localUpdate.openforWrite("fps/data/update.txt");
    for(%i=9; %i < $maxCount; %i++)
    {
             localUpdate.writeLine($newArray2[%i,0]@" "@$newArray2[%i,1]@" "@
             $newArray2[%i,2]@" "@$newArray2[%i,3]@" "@$newArray2[%i,4]@" "@$newArray2[%i,5]);
    }
    localUpdate.close();
    localUpdate.delete();
}

//----------------------------------------------------------------------------
// Parse the return from the server.
// Go through this till we get past the header and into the data.
// Gets called for each line of ASCII recieved.
//----------------------------------------------------------------------------

//Called anytime the server sends information to the client (specifically, when the server responds to the GET update.txt)
function TCPObj::onLine(%this, %line)
{
	echo(%line);

	//If we've reached the "END" line of the update.txt file
	if (%line$= "END")
	{
		//Iterate through newArray and breakup lines into newArray2
		//Start at j= 9, To skip http GET status information
		for (%j = 9; %j <= $maxCount; %j++)
			{
				%temp = $newArray[%j];

				//Break up each line in update.txt from server
				%temp0 = GetWord(%temp, 0);
				%temp1 = GetWord(%temp, 1);
				%temp2 = GetWord(%temp, 2);
				%temp3 = GetWord(%temp, 3);
				%temp4 = GetWord(%temp, 4);
				%temp5 = GetWord(%temp, 5);

				//Save the parts of the line for later use
				$newArray2[%j,0] = %temp0;
				$newArray2[%j,1] = %temp1;
				$newArray2[%j,2] = %temp2;
				$newArray2[%j,3] = %temp3;
				$newArray2[%j,4] = %temp4;
				$newArray2[%j,5] = %temp5;
			}
	}
	else if(%line !$= "")
	{
		//Store received line for later processing (If it's not the "END" line)
		$newArray[$maxCount] = %line;
		//error($newArray[$maxCount]);
		$maxCount++;
	}
}