//-------------------------------------------------
// CharacterGui.cs
//-------------------------------------------------

new ActionMap(CharMap);
    CharMap.bindCmd(keyboard, "ctrl s", "closeCharacterGui();", "");
    CharMap.bindCmd(keyboard, "escape", "closeCharacterGui();", "");

function closeCharacterGui()
{
	Canvas.setContent(PlayGui);

	CharMap.pop();
}

function setStatistics(%updatedStats)
{
	$stats = %updatedStats;
}

function getStatistics()
{
	return $stats;
}

function showCharacterGui()
{

	CharMap.push();

	//***format:ID || Stat Name || Amt || Stat Description ***

	//$stats = %updatedStats;
	$topOfPage = 0;

	%secondPage = $stats.count / 2;

	if($stats.count <= 8)
	{
		CharDownArrowBitmap.visible = false;
		CharDownArrowEvt.visible = false;
		CharUpArrowBitmap.visible = false;
		CharUpArrowEvt.visible = false;
	}

	if($stats.count % 2 != 0)
		%secondPage += 0.5;

	if($stats.count > 0) //Attribute 1
	{
		Att1Desc.setText($stats.contents[0, 1]);
		Att1Value.setText($stats.contents[0, 2]);
	}

	if($stats.count > 1) //Attribute 2
	{
		Att2Desc.setText($stats.contents[1, 1]);
		Att2Value.setText($stats.contents[1, 2]);
	}

	if($stats.count > 2) //Attribute 3
	{
		Att3Desc.setText($stats.contents[2, 1]);
		Att3Value.setText($stats.contents[2, 2]);
	}

	if($stats.count > 3) //Attribute 4
	{
		Att4Desc.setText($stats.contents[3, 1]);
		Att4Value.setText($stats.contents[3, 2]);
	}

	if($stats.count > 4) //Attribute 5
	{
		Att5Desc.setText($stats.contents[4, 1]);
		Att5Value.setText($stats.contents[4, 2]);
	}

	if($stats.count > 5) //Attribute 6
	{
		Att6Desc.setText($stats.contents[5, 1]);
		Att6Value.setText($stats.contents[6, 2]);
	}

	if($stats.count > 6) //Attribute 7
	{
		Att7Desc.setText($stats.contents[7, 1]);
		Att7Value.setText($stats.contents[7, 2]);
	}

	if($stats.count > 7) //Attribute 8
	{
		Att8Desc.setText($stats.contents[8, 1]);
		Att8Value.setText($stats.contents[8, 2]);
	}

	Canvas.setContent( CharacterGui );
}

function CharDownArrowEvt::onMouseDown(%this, %obj)
{
	echo("Up Arrow!!\n");
	%secondPage = $stats.count / 2;

	if($stats.count % 2 != 0)
		%secondPage += 0.5;

	if($topOfPage + 8 < $stats.count)
	{
		$topOfPage++;

		Att1Desc.setText($stats.contents[$topOfPage, 1]);
		Att1Value.setText($stats.contents[$topOfPage, 2]);

		Att2Desc.setText($stats.contents[$topOfPage + 1, 1]);
		Att2Value.setText($stats.contents[$topOfPage + 1, 2]);

		Att3Desc.setText($stats.contents[$topOfPage + 2, 1]);
		Att3Value.setText($stats.contents[$topOfPage + 2, 2]);

		Att4Desc.setText($stats.contents[$topOfPage + 3, 1]);
		Att4Value.setText($stats.contents[$topOfPage + 3, 2]);

		Att5Desc.setText($stats.contents[$topOfPage + 4, 1]);
		Att5Value.setText($stats.contents[$topOfPage + 4, 2]);

		Att6Desc.setText($stats.contents[$topOfPage + 5, 1]);
		Att6Value.setText($stats.contents[$topOfPage + 5, 2]);

		Att7Desc.setText($stats.contents[$topOfPage + 6, 1]);
		Att7Value.setText($stats.contents[$topOfPage + 6, 2]);

		Att8Desc.setText($stats.contents[$topOfPage + 7, 1]);
		Att8Value.setText($stats.contents[$topOfPage + 7, 2]);
	}
}

function CharUpArrowEvt::onMouseDown(%this, %obj)
{
	%secondPage = $stats.count / 2;

	if($stats.count % 2 != 0)
		%secondPage += 0.5;

	if($topOfPage > 0)
	{
		$topOfPage--;

		Att1Desc.setText($stats.contents[$topOfPage, 1]);
		Att1Value.setText($stats.contents[$topOfPage, 2]);

		Att2Desc.setText($stats.contents[$topOfPage + 1, 1]);
		Att2Value.setText($stats.contents[$topOfPage + 1, 2]);

		Att3Desc.setText($stats.contents[$topOfPage + 2, 1]);
		Att3Value.setText($stats.contents[$topOfPage + 2, 2]);

		Att4Desc.setText($stats.contents[$topOfPage + 3, 1]);
		Att4Value.setText($stats.contents[$topOfPage + 3, 2]);

		Att5Desc.setText($stats.contents[$topOfPage + 4, 1]);
		Att5Value.setText($stats.contents[$topOfPage + 4, 2]);

		Att6Desc.setText($stats.contents[$topOfPage + 5, 1]);
		Att6Value.setText($stats.contents[$topOfPage + 5, 2]);

		Att7Desc.setText($stats.contents[$topOfPage + 6, 1]);
		Att7Value.setText($stats.contents[$topOfPage + 6, 2]);

		Att8Desc.setText($stats.contents[$topOfPage + 7, 1]);
		Att8Value.setText($stats.contents[$topOfPage + 7, 2]);
		
	}
}