// Custom Profiles for the RSS Gui

// Profile for the Scroll Control
new GuiControlProfile ("RSSScrollProfile")
{
   opaque = true;					// Not transparent
   fillColor = "140 140 120"; // Fill color in RGB
   border = false;				// The control has no border
   bitmap = "./demoScroll";			// Name of the image file to use for the control 
   hasBitmapArray = true;  	// Image is a bitmap array
};

// Basic text profile
new GuiControlProfile ("RSSTextProfile")
{
   opaque = true;						// Not Transparent
	fillColor = "140 140 120";		// Background fill color
	fillColorHL = "70 70 60";  	// Color of the highlight bar
   fontColor = "0 0 0";				// Color of the font
   fontColorHL = "255 255 255";	// Color of the font when highlighted
   border = false;					// No border
};

// Gui Window profile
new GuiControlProfile ("RSSWindowProfile")
{
   opaque = true;						// Not Transparent
   border = 2;							// Has a border
   fillColor = "0 0 0";				// Window fill color
   fillColorHL = "221 202 173";	// Highlight fill color
   fillColorNA = "221 202 173";  // Not available fill color
   fontColor = "255 255 255";		// Text color
   fontColorHL = "255 255 255";	// Color of text when highlighted
   bitmap = "./window";				// Name of the image file to use for the control
   textOffset = "6 6";				//	
   hasBitmapArray = true;			// Image is a bitmap array
   justify = "center";				// Text is centered on the Title Bar
};

// Inherit text properties from RSSTextProfile, expand for Large Text Profile
new GuiControlProfile (RSSBigTextProfile : RSSTextProfile)
{
	fontColor = "255 255 255";		// Set color to white
   fontSize = 36;						// Change font size to 36
};

// Inherit text properties from RSSTextProfile, expand for Small Text Profile
new GuiControlProfile (RSSSmallTextProfile : RSSTextProfile)
{
	fontColor = "255 255 255";		// Set color to white
};

// Markup Language text box profile
new GuiControlProfile (RSSMLTextProfile)
{
   fontColorLink = "255 0 0";		//	Color of hyperlinks
   fontColorLinkHL = "0 0 255";	// Color of active hyperlinks
};

// Color of text in the listbox
new GuiControlProfile (RSSTextListProfile : RSSTextProfile) ;

// Button profile
new GuiControlProfile (RSSButtonProfile)
{
   opaque = true;						// Not transparent
   border = true;						// Has a border
   fontColor = "255 255 255";		// Font Color
   fontColorHL = "255 0 0";		// Font Color when selected
   fillColor = "50 50 50";			// Color of the button
   fillColorHL = "75 75 75";		// Color of the button when highlighted
   fillColorNA = "25 25 25";		// Color of the button when unavailable
   fixedExtent = true;				// Fixed size
   justify = "center";				// Text centered on button
	canKeyFocus = false;				// can not select with keyboard
};