//----------------------------
// Torque RSS Viewer
// By: Harold "LabRat" Brown
// Date: October 18, 2003
//----------------------------

//----------------------------
// CONFIGURATION
//----------------------------


$rss::site = "primo.arts.uci.edu:80"; // The URL and port to your webserver.  Do not include http:// 
$rss::folder = "/torque/"; // Path to the rssnews.php file on your webserver, include leading and trailing /'s
$rss::url = "";  // Should always be blank


//----------------------------
// Function to initialize the
// RSS Viewer
//----------------------------
	
function initRSSView() {
	// Load GUI Profile
	exec("./ui/rssguiprofiles.cs");
	
	// Load GUI
	exec("./ui/rssGui.gui");
	
	// Load core functions
	exec("./rssGui.cs");

	// Flag to denote if recieving RSS information
	TCPObj.rsson = false;
 
 
 	// Button to be added to the MainMenuGui
	new GuiButtonCtrl(loadrss) {
   	profile = "GuiButtonProfile";
   	horizSizing = "right";
   	vertSizing = "top";
   	position = "36 345";
   	extent = "110 20";
   	minExtent = "8 8";
   	visible = "1";
   	command = "Canvas.setcontent(rssgui);";
   	text = "RSS Feeds";
   	groupNum = "-1";
   	buttonType = "PushButton";
   	helpTag = "0";
	};
   
   // Add the button to the mainmenugui
	mainmenugui.add(loadrss);
	
	//load the feeds into the list
	loadfeeds();
}


//-----------------------------
// RSS Viewer MOD package
//-----------------------------
package RSSView {

//-----------------------------
// Function to load our MOD 
//-----------------------------

function onStart()
{
	// Let the base MOD load first
   Parent::onStart();
   
   // Print to the Console to show we've started
   echo("\n--------- Initializing MOD: RSS Viewer ---------");
   
   // Call the Initialization function
   initRSSView();
}

}; 

// Activate our package
activatePackage(RSSView);

